/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CSubsystems.h,v 1.2 1999/09/17 04:20:45 nryan Exp $
____________________________________________________________________________*/

#ifndef Included_CSubsystems_h	// [
#define Included_CSubsystems_h

#include "pgpClassesConfig.h"

#include "CErrorState.h"
#include "SingletonMacros.h"

_PGP_BEGIN

// Macros for declaring subsystem variables and functions

#define DECLARE_SUBSYSTEM(type, name)							\
	protected:													\
		static type	*m##name;									\
																\
	public:														\
		static type&	name();									\
																\
		static SMART_ERROR	Create##name();						\
		static void			Destroy##name();


#if PGP_EXCEPTIONS

// Macros for defining subsystem variables and functions

#define DEFINE_SUBSYSTEM(type, hostclass, name)					\
	type	*hostclass::m##name	= NULL;							\
																\
	type&														\
	hostclass::name()											\
	{															\
		return *m##name;										\
	}															\
																\
	void														\
	hostclass::Create##name()									\
	{															\
		if (IsNull(m##name))									\
		{														\
			m##name = new type;									\
																\
			try													\
			{													\
				m##name->Startup();								\
			}													\
			catch (CComboError&)								\
			{													\
				delete m##name;									\
				m##name = NULL;									\
																\
				throw;											\
			}													\
		}														\
	}															\
																\
	void														\
	hostclass::Destroy##name()									\
	{															\
		if (IsntNull(m##name))									\
		{														\
			pgpAssertAddrValid(m##name, type);					\
			m##name->Shutdown();								\
																\
			delete m##name;										\
			m##name = NULL;										\
		}														\
	}


// Macros for invoking subsystem creation/destruction

#define CALL_MAKE_SUBSYSTEM(name)								\
	Create##name();

#define CALL_DESTROY_SUBSYSTEM(name)							\
	Destroy##name();

#else	// !PGP_EXCEPTIONS

// Macros for defining subsystem variables and functions

#define DEFINE_SUBSYSTEM(type, hostclass, name)							\
	type	*hostclass::m##name	= NULL;									\
																		\
	type&																\
	hostclass::name()													\
	{																	\
		return *m##name;												\
	}																	\
																		\
	CComboError															\
	hostclass::Create##name()											\
	{																	\
		CComboError	error;												\
																		\
		if (IsNull(m##name))											\
		{																\
			if (IsNull(m##name = new type))								\
				error.pgpErr = kPGPError_OutOfMemory;					\
		}																\
																		\
		if (error.IsntError())											\
		{																\
			error = m##name->Status();									\
																		\
			if (error.IsntError())										\
				error = m##name->Startup();								\
																		\
			if (error.IsError())										\
			{															\
				delete m##name;											\
				m##name = NULL;											\
			}															\
		}																\
																		\
		return error;													\
	}																	\
																		\
	void																\
	hostclass::Destroy##name()											\
	{																	\
		if (IsntNull(m##name))											\
		{																\
			pgpAssertAddrValid(m##name, type);							\
																		\
			m##name->Shutdown();										\
																		\
			delete m##name;												\
			m##name = NULL;												\
		}																\
	}


// Macros for invoking subsystem creation/destruction

#define CALL_MAKE_SUBSYSTEM(name)										\
	if (error.IsntError())												\
		error = Create##name();

#define CALL_DESTROY_SUBSYSTEM(name)									\
	Destroy##name();

#endif	// PGP_EXCEPTIONS

// Class CSubsystems

class CSubsystems SMART_ERROR_INHERIT
{
	NOT_COPYABLE(CSubsystems)
	DECLARE_SINGLETON_VARIABLE(CSubsystems)

public:
			CSubsystems() { }
	virtual	~CSubsystems() = 0 { }

	static SMART_ERROR	CreateSubsystems();
	static void			DestroySubsystems();

protected:
	virtual SMART_ERROR	CreateSubsystemsAux() = 0
	{
		SMART_ERROR_CALL CComboError();
	}

	virtual void		DestroySubsystemsAux() = 0
	{
	}
};

_PGP_END

#endif	// Included_CSubsystems_h
